/*
 * Copyright (C) 2011-2021 Intel Corporation. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in
 *     the documentation and/or other materials provided with the
 *     distribution.
 *   * Neither the name of Intel Corporation nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
import Sequelize from 'sequelize';

export default class Platforms extends Sequelize.Model {
  static init(sequelize) {
    super.init(
      {
        qe_id: { type: Sequelize.DataTypes.STRING, primaryKey: true },
        pce_id: { type: Sequelize.DataTypes.STRING, primaryKey: true },
        platform_manifest: {
          type: Sequelize.DataTypes.BLOB,
          // store binary data in DB
          get() {
            return (this.getDataValue('platform_manifest') || '').toString('hex');
          },
          set(value) {
            this.setDataValue('platform_manifest', Buffer.from(value, 'hex'));
          },
        },
        enc_ppid: {
          type: Sequelize.DataTypes.BLOB,
          // store binary data in DB
          get() {
            return (this.getDataValue('enc_ppid') || '').toString('hex');
          },
          set(value) {
            this.setDataValue('enc_ppid', Buffer.from(value, 'hex'));
          },
        },
        fmspc: { type: Sequelize.DataTypes.STRING },
        ca: { type: Sequelize.DataTypes.STRING },
      },
      {
        tableName: 'platforms',
        timestamps: true,
        createdAt: 'created_time',
        updatedAt: 'updated_time',
        sequelize,
      }
    );
  }
}
